<?php
session_start();
include '../assets/constant/config.php';

try {
    $conn = new PDO("mysql:host=$servername;dbname=$dbname", $username, $password);
    $conn->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

    if ($_SERVER['REQUEST_METHOD'] == 'POST') {
        $payment_id = $_POST['payment_id'];
        $member = $_POST['member'];
        $amount = $_POST['amount'];
        $date = $_POST['date'];
        $paymentmethod = $_POST['paymentmethod'];
        $notes = $_POST['notes'];

        $stmt = $conn->prepare("INSERT INTO payment (payment_id, member, amount, date, paymentmethod, notes) VALUES (:payment_id, :member, :amount, :date, :paymentmethod, :notes)");
        $stmt->bindParam(':payment_id', $payment_id);
        $stmt->bindParam(':member', $member);
        $stmt->bindParam(':amount', $amount);
        $stmt->bindParam(':date', $date);
        $stmt->bindParam(':paymentmethod', $paymentmethod);
        $stmt->bindParam(':notes', $notes);

        if ($stmt->execute()) {
            echo json_encode(['status' => 'success', 'message' => 'Payment recorded successfully']);
        } else {
            echo json_encode(['status' => 'error', 'message' => 'Failed to record payment']);
        }
    }
} catch (PDOException $e) {
    echo json_encode(['status' => 'error', 'message' => 'Connection failed: ' . $e->getMessage()]);
}
?>