<?php
session_start();
include '../../assets/constant/config.php';

try {
    $conn = new PDO("mysql:host=$servername;dbname=$dbname", $username, $password);
    $conn->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);


if (isset($_POST['submit'])) {
    // Extracting form data
    $branch = $_POST['branch'];
    $member = $_POST['member'];
    $amounts = $_POST['amount'];
    $batches = $_POST['batch'];
    $contritypes = $_POST['contritype'];
    $funds = $_POST['fund'];
    $paymentmethods = $_POST['paymentmethod'];
    $date = $_POST['date'];

    // Loop through dynamic fields
    foreach($amounts as $key => $amount) {
        // Ensure that all required fields have values before proceeding
        if (!empty($amount) && !empty($batches[$key]) && !empty($contritypes[$key]) && !empty($funds[$key]) && !empty($paymentmethods[$key])) {
            $batch = $batches[$key];
            $contritype = $contritypes[$key];
            $fund = $funds[$key];
            $paymentmethod = $paymentmethods[$key];

            // Prepare the SQL statement
            $stmt = $conn->prepare("INSERT INTO contribution (branch, member, amount, batch, contritype, fund, paymentmethod, date) VALUES (:branch, :member, :amount, :batch, :contritype, :fund, :paymentmethod, :date)");

            // Bind parameters
            $stmt->bindParam(':branch', $branch);
            $stmt->bindParam(':member', $member);
            $stmt->bindParam(':amount', $amount);
            $stmt->bindParam(':batch', $batch);
            $stmt->bindParam(':contritype', $contritype);
            $stmt->bindParam(':fund', $fund);
            $stmt->bindParam(':paymentmethod', $paymentmethod);
            $stmt->bindParam(':date', $date);

            // Execute the statement
            $stmt->execute();
        }
    }

    $_SESSION['success'] = "success";
    header("location:../manage_contribution.php");
    exit;
}



// if ($_SERVER['REQUEST_METHOD'] == 'POST') {
//     if (isset($_POST['submit'])) {
//         // Handle form submission
//         // Save form data to database and return success response
//         // The data is saved temporarily until payment is confirmed
//         // You might want to return a response with a temporary record ID
//         // and the amount for the payment

//         // You should add validation and sanitation of input here

//         $branch = $_POST['branch'];
//         $member = $_POST['member'];
//         $amounts = $_POST['amount'];
//         $batches = $_POST['batch'];
//         $contritypes = $_POST['contritype'];
//         $funds = $_POST['fund'];
//         $paymentmethods = $_POST['paymentmethod'];
//         $date = $_POST['date'];

//         // Insert the form data into a temporary table or mark as unpaid
//         $stmt = $conn->prepare("INSERT INTO contribution (branch, member, date, status) VALUES (?, ?, ?, 'unpaid')");
//         $stmt->execute([$branch, $member, $date]);
//         $contribution_id = $conn->lastInsertId();

//         foreach ($amounts as $index => $amount) {
//             // Only insert if amount is not empty
//             if (!empty($amount)) {
//                 $batch = $batches[$index];
//                 $contritype = $contritypes[$index];
//                 $fund = $funds[$index];
//                 $paymentmethod = $paymentmethods[$index];

//                 $stmt = $conn->prepare("INSERT INTO contribution_details (contribution_id, amount, batch, contritype, fund, paymentmethod) VALUES (?, ?, ?, ?, ?, ?)");
//                 $stmt->execute([$contribution_id, $amount, $batch, $contritype, $fund, $paymentmethod]);
//                 $_SESSION['success'] = "success";
//             }
//         }

//         header("location:../manage_contribution.php");
//     } elseif (isset($_POST['payment_id']) && $_POST['action'] == 'finalize_payment') {
//         // Handle payment finalization
//         // Update the temporary record to mark it as paid
//         $payment_id = $_POST['payment_id'];
//         $contribution_id = $_POST['contribution_id']; // Get the contribution_id from the request

//         // Update status in the database
//         $stmt = $conn->prepare("UPDATE contribution SET status = 'paid', payment_id = ? WHERE id = ?");
//         $stmt->execute([$payment_id, $contribution_id]);

//         echo json_encode(['success' => true]);
//     }
// }












//delete contribution



    if (isset($_POST['del_id'])) {

        $stmt = $conn->prepare("UPDATE `contribution` SET delete_status='1' where id=? ");

        $stmt->execute([htmlspecialchars($_POST['del_id'], ENT_QUOTES, 'UTF-8')]);

        $_SESSION['delete'] = "delete";

        header("location:../manage_contribution.php");
    }

} catch (PDOException $e) {
    echo "Connection failed: " . $e->getMessage();
}
?>